﻿[CmdletBinding()]
param(
    # Specify New Folder Name.
    [string] $PWFolderName = 'PDFs',
    # Specify New Folder Description.
    [string] $PWFolderDescription = 'Contains PDF files',
    # Specify Environment to be used. Not required.
    [string] $PWEnvironment = 'Complex',
    # Specify storage area to be used.
    [string] $PWStorageArea = 'Storage_01'
)
BEGIN {   
    $StartTime = Get-Date 
    Write-Verbose -Message "[BEGIN] Start time: $StartTime"
} # end BEGIN

PROCESS { 
    <# Returns ProjectWise folder objects for all 
        Rich Projects / Work Areas found in the current datasource. #>
    $PWRichProjects = Get-PWRichProjects -Verbose

    # Loop thru all projects returned and add new sub-folder. 
    foreach ( $PWRichProject in $PWRichProjects ) {
        # Using splatting for readability. 
        $NewFolderInfo = @{ 
            FolderPath = "$($PWRichProject.FullPath)\$PWFolderName" 
            Description = $PWFolderDescription 
            Environment = $PWEnvironment 
            <# You can also set the storage area to that of the parent
                rich project storage area. #> 
            #StorageArea = $PWRichProject.Storage 
            StorageArea = $PWStorageArea 
        } 
        try {
            $pwFolder = New-PWFolder @NewFolderInfo -ErrorAction Stop
        } catch {
            Write-Warning -Message "[PROCESS] Error occurred while attempting to add sub-folder to '$($PWRichProject.Name)'. $($Error[0].Exception)"
        }
    } # end foreach ( $PWRichProject...
    
} # end PROCESS

END {
    $EndTime = Get-Date
    Write-Verbose -Message "[END] It took $([Math]::Round($EndTime.Subtract($StartTime).TotalMinutes, 2)) minutes to complete process."
} # end END